<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/tv/default_channel.php';

///////////////////////////////////////////////////////////////////////////

class FlussonicChannel extends DefaultChannel
{
    private $number;
	private $has_archive;
    private $past_epg_days;
    private $future_epg_days;
	private $protectcode;
    ///////////////////////////////////////////////////////////////////////

    public function __construct(
        $id, $title, $icon_url, $streaming_url, $number, $past_epg_days, $future_epg_days, $protectcode, $has_archive, $archive_past_days)
    {
        parent::__construct($id, $title, $icon_url, $streaming_url, $protectcode);

        $this->number = $number;
		$this->has_archive = $has_archive;
		$this->protectcode = $protectcode;
        $this->past_epg_days = $past_epg_days;
        $this->future_epg_days = $future_epg_days;
        $this->archive_past_days = $archive_past_days;
    }

    ///////////////////////////////////////////////////////////////////////

    public function get_number()
    { return $this->number; }
	
	public function is_protected()
    { return $this->protectcode; }
	
	public function has_archive()
    { return $this->has_archive; }
    
    public function get_past_epg_days()
    { return $this->past_epg_days; }

    public function get_future_epg_days()
    { return $this->future_epg_days; }

    public function get_archive_past_sec()
    { return $this->archive_past_days * 86400;}
}

///////////////////////////////////////////////////////////////////////////
?>
