<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/default_dune_plugin.php';
require_once 'lib/utils.php';

require_once 'lib/tv/tv_group_list_screen.php';
require_once 'lib/tv/tv_favorites_screen.php';

require_once 'lib/vod/vod_list_screen.php';
require_once 'lib/vod/vod_movie_screen.php';
require_once 'lib/vod/vod_series_list_screen.php';
require_once 'lib/vod/vod_favorites_screen.php';

require_once 'flussonic_config.php';

require_once 'flussonic_tv.php';
require_once 'flussonic_m3u_tv.php';
require_once 'flussonic_vod.php';
require_once 'flussonic_setup_screen.php';
require_once 'flussonic_tv_channel_list_screen.php';
require_once 'flussonic_vod_category_list_screen.php';
require_once 'flussonic_vod_list_screen.php';
require_once 'flussonic_main_screen.php';

///////////////////////////////////////////////////////////////////////////

class FlussonicPlugin extends DefaultDunePlugin
{
    public function __construct()
    {
        $this->tv =
            FlussonicConfig::USE_M3U_FILE ?
            new FlussonicM3uTv() :
            new FlussonicTv();

        $this->vod = new FlussonicVod();

        if (FlussonicConfig::USE_M3U_FILE)
        {
            // $this->add_screen(new TvGroupListScreen($this->tv,
            //         FlussonicConfig::GET_TV_GROUP_LIST_FOLDER_VIEWS()));
            $this->add_screen(new Flussonic_MainScreen($this->tv,
                    FlussonicConfig::GET_TV_GROUP_LIST_FOLDER_VIEWS()));        
        }

        $this->add_screen(new FlussonicTvChannelListScreen($this->tv,
                FlussonicConfig::GET_TV_CHANNEL_LIST_FOLDER_VIEWS()));
        $this->add_screen(new TvFavoritesScreen($this->tv,
                FlussonicConfig::GET_TV_CHANNEL_LIST_FOLDER_VIEWS()));

        $this->add_screen(new FlussonicSetupScreen($this->tv,
                FlussonicConfig::GET_TV_CHANNEL_LIST_FOLDER_VIEWS()));
				
        $this->add_screen(new VodFavoritesScreen($this->vod));
        $this->add_screen(new FlussonicVodCategoryListScreen());
        $this->add_screen(new FlussonicVodListScreen($this->vod));
        $this->add_screen(new VodMovieScreen($this->vod));
        $this->add_screen(new VodSeriesListScreen($this->vod));
    }
}

///////////////////////////////////////////////////////////////////////////
?>
