﻿<?php

class FlussonicConfig
{
    const PluginVersion             = '1.1.3';
    const PluginDate                = '09.04.24';

    const VOD_MOVIE_PAGE_SUPPORTED = false;
    const VOD_FAVORITES_SUPPORTED  = false;
    const TV_FAVORITES_SUPPORTED   = true;

    const USER_INFO              = "http://srv4you.net/api/v1/customers/expired_packet/%s/";
    const CHANNEL_LIST_HOST      = 'http://pl.is-a-player.com';
    const CHANNEL_LIST_HOST2     = 'http://srv4you.net';

    // EPG_URL_FORMAT defines format string for the EPG-fetching-URL.
    // If it is null, EPG is not supported and will not be shown.
    const EPG_URL_FORMAT        = 'http://json.is-a-player.com/epg-server/epg_day?id=%s&day=%s';
    const VOD_CATEGORIES_URL    = 'http://online.dune-hd.com/flussonic2/vod_categories.pl'; 
    const MOVIE_LIST_URL_FORMAT = 'http://online.dune-hd.com/flussonic2/movie_list.pl?category_id=%s';
    const MOVIE_INFO_URL_FORMAT = 'http://online.dune-hd.com/flussonic2/movie_info.pl?movie_id=%s';

    const ALL_CHANNEL_GROUP_CAPTION     = '%tr%t2'; //Все каналы
    const ALL_CHANNEL_GROUP_ICON_PATH   = 'plugin_file://icons/all2.png';
    const PLUGIN_SETUP                  = 'plugin_file://icons/setup.png';

    const FAV_CHANNEL_GROUP_CAPTION     = '%tr%t1'; //Избранное
    const FAV_CHANNEL_GROUP_ICON_PATH   = 'plugin_file://icons/fav2.png';

    const FAV_MOVIES_CATEGORY_CAPTION   = '%tr%t1'; //Избранное
    const FAV_MOVIES_CATEGORY_ICON_PATH = 'plugin_file://icons/fav.png';

    // NOTE: see also comments in dune_plugin.xml
    const USE_M3U_FILE = true;

    const M3U_FILE_URL = 'plugin_file://SHURIK-EPG-m3u8_russia.m3u8';
    //const M3U_FILE_URL = 'http://online.dune-hd.com/flussonic2/m3u/iptv.utf8.m3u';

    // const M3U_ICON_FILE_URL_FORMAT = 'plugin_file://icons/%s.aai';
    const M3U_ICON_FILE_URL_FORMAT = 'http://online.dune-hd.com/flussonic2/m3u/%s.aai';
    const M3U_ICON_GROUP_FILE_URL_FORMAT = 'http://icon.srv4you.net';

    // CHANNEL_SORT_FUNC_CB defines the function name to be used as a callback
    // to sort IPTV-channels.
    //
    // If it is null, sorting will not be performed.
    const CHANNEL_SORT_FUNC_CB = 'FlussonicConfig::sort_channels_cb';

    ///////////////////////////////////////////////////////////////////////
    // How to sort IPTV-channels.

    public static function sort_channels_cb($a, $b)
    {
        // Sort by channel numbers.
        return strnatcasecmp($a->get_number(), $b->get_number());

        // Other options:
        // return strnatcasecmp($a->get_title(), $b->get_title());
    }

    ///////////////////////////////////////////////////////////////////////
    // Folder views.

    public static function GET_TV_GROUP_LIST_FOLDER_VIEWS()
    {
        return array(
            array
            (
                PluginRegularFolderView::async_icon_loading => false,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 5,
                    ViewParams::num_rows => 3,
                    ViewParams::paint_details => false,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => 'gui_skin://special_icons/sandwich_base.aai',
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => 'cut_icon://{name=sandwich_cover}',
                    ViewParams::sandwich_width => 200,
                    ViewParams::sandwich_height => 120,
                    ViewParams::content_box_padding_left => 70,
		            ViewParams::background_path=> 'plugin_file://icons/bg.jpg',
		            ViewParams::background_order => 0,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => false,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => true,
                    ViewItemParams::icon_scale_factor => 1.2,
                    ViewItemParams::icon_sel_scale_factor => 1.2,
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
            
            array
            (
                PluginRegularFolderView::async_icon_loading => false,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 5,
                    ViewParams::num_rows => 4,
                    ViewParams::paint_details => false,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => 'gui_skin://special_icons/sandwich_base.aai',
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => 'cut_icon://{name=sandwich_cover}',
                    ViewParams::sandwich_width => 245,
                    ViewParams::sandwich_height => 140,
                    ViewParams::content_box_padding_left => 70,
                    ViewParams::background_path=> 'plugin_file://icons/bg.jpg',
                    ViewParams::background_order => 0,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => false,
                    ViewItemParams::icon_scale_factor => 1.0,
                    ViewItemParams::icon_sel_scale_factor => 1.2,
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),

            array
            (
                PluginRegularFolderView::async_icon_loading => false,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 4,
                    ViewParams::num_rows => 3,
                    ViewParams::paint_details => false,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => 'gui_skin://special_icons/sandwich_base.aai',
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => 'cut_icon://{name=sandwich_cover}',
                    ViewParams::sandwich_width => 245,
                    ViewParams::sandwich_height => 140,
                    ViewParams::content_box_padding_left => 70,
		            ViewParams::background_path=> 'plugin_file://icons/bg.jpg',
		            ViewParams::background_order => 0,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => false,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => false,
                    ViewItemParams::icon_scale_factor => 1.25,
                    ViewItemParams::icon_sel_scale_factor => 1.5,
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
        );
    }
    
    public static function GET_TV_CHANNEL_LIST_FOLDER_VIEWS()
    {
        return array(
            array
            (
                PluginRegularFolderView::async_icon_loading => true,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 2,
                    ViewParams::num_rows => 10,
                    ViewParams::background_path=> 'plugin_file://icons/bg.jpg',
                    ViewParams::background_order => 0,
                    ViewParams::paint_details => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_LEFT,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::icon_dx => 10,
                    ViewItemParams::icon_dy => -5,
                    ViewItemParams::icon_width => 82,
                    ViewItemParams::icon_height => 47,
                    ViewItemParams::item_caption_width => 485,
                    ViewItemParams::item_caption_font_size => FONT_SIZE_SMALL,
                    ViewItemParams::icon_path => 'plugin_file:///channel_unset.png',
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
            array
            (
                PluginRegularFolderView::async_icon_loading => true,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 2,
                    ViewParams::num_rows => 15,
                    ViewParams::background_path=> 'plugin_file://icons/bg.jpg',
		            ViewParams::background_order => 0,
                    ViewParams::paint_details => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_LEFT,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::icon_dx => 10,
                    ViewItemParams::icon_dy => -5,
                    ViewItemParams::icon_width => 75,
                    ViewItemParams::icon_height => 43,
                    ViewItemParams::item_caption_width => 485,
                    ViewItemParams::item_caption_font_size => FONT_SIZE_SMALL,
                    ViewItemParams::icon_path => 'plugin_file://icons/channel_unset.png',
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),

        );
    }

    public static function GET_VOD_MOVIE_LIST_FOLDER_VIEWS()
    {
        return array(
            array
            (
                PluginRegularFolderView::async_icon_loading => true,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 6,
                    ViewParams::num_rows => 3,
                    ViewParams::background_path=> 'plugin_file://icons/bg.jpg',
		            ViewParams::background_order => 0,
                    ViewParams::icon_selection_box_width => 150,
                    ViewParams::icon_selection_box_height => 222,
                    ViewParams::paint_details => true,
                    ViewParams::zoom_detailed_icon => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_padding_top => 0,
                    ViewItemParams::item_padding_bottom => 0,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => false,
                    ViewItemParams::icon_scale_factor => 1.0,
                    ViewItemParams::icon_sel_scale_factor => 1.2,
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array
                (
                    ViewItemParams::icon_path => 'plugin_file://icons/mov_unset.png',
                    ViewItemParams::item_detailed_icon_path => 'missing://',
                ),
            ));
    }

    public static function GET_VOD_CATEGORY_LIST_FOLDER_VIEWS()
    {
        return array(
            array
            (
                PluginRegularFolderView::async_icon_loading => false,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 5,
                    ViewParams::num_rows => 4,
                    ViewParams::paint_details => false,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => 'gui_skin://special_icons/sandwich_base.aai',
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => 'cut_icon://{name=sandwich_cover}',
                    ViewParams::sandwich_width => 245,
                    ViewParams::sandwich_height => 140,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => false,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => false,
                    ViewItemParams::icon_scale_factor => 1.0,
                    ViewItemParams::icon_sel_scale_factor => 1.2,
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),

            array
            (
                PluginRegularFolderView::async_icon_loading => false,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 4,
                    ViewParams::num_rows => 3,
                    ViewParams::paint_details => false,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => 'gui_skin://special_icons/sandwich_base.aai',
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => 'cut_icon://{name=sandwich_cover}',
                    ViewParams::sandwich_width => 245,
                    ViewParams::sandwich_height => 140,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => false,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => false,
                    ViewItemParams::icon_scale_factor => 1.25,
                    ViewItemParams::icon_sel_scale_factor => 1.5,
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
        );
    }

    public static function get_packet_info($url, $billing_id){
        $packet_info = array();
        
        try {
            $json_string = HD::http_get_document($url);
        
            if (trim($json_string) == ""){
                array_push($packet_info, array('packet' => '%tr%t44', 'exp' => '0')); //Данные не найдены
            } else if (trim($json_string) == "404") {
                if($billing_id == 1){
                    array_push($packet_info, array('packet' => '%tr%t52', 'exp' => '404')); //В разработке
                } else {
                    array_push($packet_info, array('packet' => '%tr%t45', 'exp' => '404')); //Неверный ключ
                }
            } else if (trim($json_string) == "401") {
                array_push($packet_info, array('packet' => '%tr%t46', 'exp' => '401')); //Нет активных подписок
            } else {
                $json_object = json_decode($json_string);
                foreach ($json_object as &$pckt_info) {
                    array_push($packet_info, array(
                        'packet' => $pckt_info->{'packet'},
                        'exp' => gmdate("d.m.Y  H:i", substr($pckt_info->{'expired'}, 0, strlen($pckt_info->{'expired'}) - 3))
                    ));
                }
            }
        } catch (Exception $e) {
            hd_print("Can't fetch package info");
        }
        
        return $packet_info;
    }
}

?>